'use strict';

/* --------------------------------------------------------------
   PayPalLoader.js 2020-10-06
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

(function () {
	if (window.NodeList && !NodeList.prototype.forEach) {
		NodeList.prototype.forEach = Array.prototype.forEach;
	}

	var currentScript = document.currentScript;

	var initDisplayModeECS_ButtonReplace = function initDisplayModeECS_ButtonReplace() {
		var paypalButtonContainer = document.querySelector('#paypal-button-container'),
		    footerTotalRow = document.querySelector('table.order-total tr.footer.total'),
		    newTotalRow = document.createElement('tr'),
		    newTotalRowCell = document.createElement('td');
		newTotalRowCell.colSpan = '2';
		newTotalRowCell.style.width = '100%';
		newTotalRowCell.style.borderTop = 'none';
		newTotalRowCell.appendChild(paypalButtonContainer);
		newTotalRow.appendChild(newTotalRowCell);
		footerTotalRow.parentNode.appendChild(newTotalRow);
		footerTotalRow.querySelectorAll('td').forEach(function (td) {
			td.style.paddingBottom = '15px';
		});
	};

	var initDisplayModeECS = function initDisplayModeECS() {
		if (window.location.search.match(/(\?|&)display_mode=ecs($|&)/)) {
			var checkoutButtons = document.querySelector('div.checkout-buttons');
			if (checkoutButtons) {
				checkoutButtons.style.display = 'none';
			}
			var checkoutSubmitButton = document.querySelector('div.shopping-cart-button a.button-submit');
			if (checkoutSubmitButton === null) {
				checkoutSubmitButton = document.querySelector('tr.checkout-button');
			}
			if (checkoutSubmitButton) {
				checkoutSubmitButton.style.display = 'none';
			}
			var shoppingCartButton = document.querySelector('div.shopping-cart-button');
			if (shoppingCartButton) {
				shoppingCartButton.classList.add('paypal-ecs-mode');
			}
			var ppiContainer = document.querySelector('div.paypalinstallmentcontainer');
			if (ppiContainer) {
				ppiContainer.style.display = 'none';
			}
			initDisplayModeECS_ButtonReplace();
		}
	};

	var initJSSDKPayPalButtonECS = function initJSSDKPayPalButtonECS() {
		var buttonContainer = document.querySelector('#paypal-button-container');
		if (!buttonContainer) {
			return;
		}
		var ecsIntro = document.querySelector('div.ecs_intro');
		if (document.querySelector('tr.checkout-button .button-disabled') !== null) {
			if (ecsIntro) {
				ecsIntro.style.display = 'none';
			}
			buttonContainer.style.display = 'none';
		} else {
			if (ecsIntro) {
				ecsIntro.style.display = 'block';
			}
			buttonContainer.style.display = 'block';
			initDisplayModeECS();
		}

		paypal.Buttons({
			style: payPalButtonSettings.style,
			createOrder: function createOrder(data, actions) {
				return $.ajax({
					url: payPalButtonSettings.createPaymentUrl,
					dataType: 'json'
				}).then(function (data) {
					var token = void 0;
					if (data.payment) {
						for (var link in data.payment.links) {
							if (data.payment.links[link].rel === 'approval_url') {
								token = data.payment.links[link].href.match(/EC-\w+/)[0];
							}
						}
					} else {
						//throw new Error(payPalText.paypalUnavailable);
						return false;
					}
					return token;
				});
			},
			onApprove: function onApprove(data, actions) {
				$.ajax({
					url: payPalButtonSettings.authorizedPaymentUrl,
					method: 'post',
					headers: {
						'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
					},
					data: 'paymentID=' + data.paymentID + '&payerID=' + data.payerID
				}).then(function (res) {
					console.debug(res);
					document.location = payPalButtonSettings.checkoutUrl;
				});
			},
			onError: function onError(err) {
				var ppButtonContainer = document.querySelector('#paypal-button-container');
				var ecsIntro = document.querySelector('div.ecs_intro');
				if (ppButtonContainer) {
					var errorMessage = document.querySelector('div.paypal-error');
					if (!errorMessage) {
						errorMessage = document.createElement('div');
						errorMessage.classList.add('paypal-error');
						errorMessage.classList.add('alert');
						errorMessage.classList.add('alert-warning');
						errorMessage.style.textAlign = 'left';
						errorMessage.style.color = '#555';
					}
					errorMessage.innerText = payPalText.paypalUnavailable + ' ';
					var shoppingCartButton = document.querySelector('div.shopping-cart-button');
					if (shoppingCartButton && shoppingCartButton.classList.contains('paypal-ecs-mode')) {
						var linkUrl = window.location.toString().replace('display_mode=ecs', 'display_mode=normal');
						var continueLink = document.createElement('a');
						continueLink.setAttribute('href', linkUrl);
						continueLink.innerText = payPalText.errorContinue;
						errorMessage.append(continueLink);
					}
					ppButtonContainer.parentNode.append(errorMessage);
					ppButtonContainer.style.display = 'none';
				}
				if (ecsIntro) {
					ecsIntro.style.display = 'none';
				}
			}
		}).render('#paypal-button-container');

		var observerTarget = document.querySelector('#paypal-button-container');
		var observer = new MutationObserver(function (mutations, observer) {
			mutations.forEach(function (mutation) {
				// console.debug(mutation);
				if (mutation.removedNodes.length > 0) {
					console.info('re-init PayPal buttons');
					initJSSDKPayPalButtonECS();
				}
			});
		});
		observer.observe(observerTarget, { childList: true });
	};

	var initJSSDKPayPalButtonECM = function initJSSDKPayPalButtonECM() {
		paypal.Buttons({
			style: payPalButtonSettings.style,
			createOrder: function createOrder(data, actions) {
				return $.ajax({
					url: payPalButtonSettings.createPaymentUrl,
					dataType: 'json'
				}).then(function (data) {
					var token = void 0;
					for (var link in data.payment.links) {
						if (data.payment.links[link].rel === 'approval_url') {
							token = data.payment.links[link].href.match(/EC-\w+/)[0];
						}
					}
					return token;
				});
			},
			onApprove: function onApprove(data, actions) {
				document.querySelector('#checkout_payment input[name="PayPal2HubPaymentId"]').value = data.paymentID;
				document.querySelector('#checkout_payment input[name="PayPal2HubPayerId"]').value = data.payerID;
				document.querySelector('#checkout_payment').submit();
			}
		}).render('#paypal-button-container');
	};

	var initCheckoutPayment = function initCheckoutPayment() {
		var continueButtonBlock = document.querySelector('#checkout_payment div.continue_button'),
		    continueButton = continueButtonBlock.querySelector('input[type="submit"]'),
		    continueButtonDisplay = continueButton.style.display,
		    paypalButtonContainer = document.createElement('div'),
		    plusContainer = document.querySelector('#gambiohub-ppplus');

		if (plusContainer === null && !payPalButtonSettings.paymentApproved) {
			paypalButtonContainer.id = 'paypal-button-container';
			paypalButtonContainer.style.display = 'none';
			continueButtonBlock.appendChild(paypalButtonContainer);

			initJSSDKPayPalButtonECM();

			var paymentItemClickListener = function paymentItemClickListener() {
				var selected_payment = this.querySelector('input[name="payment"]');
				if (null !== selected_payment) {
					if (selected_payment.value === 'gambio_hub' && selected_payment.dataset.module_code === 'PayPal2Hub') {
						continueButton.style.display = 'none';
						paypalButtonContainer.style.display = 'block';
					} else {
						continueButton.style.display = continueButtonDisplay;
						paypalButtonContainer.style.display = 'none';
					}
				}
			};

			var paymentItems = document.querySelectorAll('#checkout_payment input[name="payment"], #checkout_payment li.list-group-item');
			paymentItems.forEach(function (paymentItem) {
				paymentItem.addEventListener('click', paymentItemClickListener);
			});

			var paymentListEntries = document.querySelectorAll('#checkout_payment li');
			paymentListEntries.forEach(function (paymentOption) {
				if (paymentOption.querySelector('input[name="payment"]:checked') || paymentListEntries.length === 1) {
					paymentOption.dispatchEvent(new Event('click'));
				}
			});
		}
	};

	/****
  ****  Installment Banners
 	 */

	var initInstallmentBanners = function initInstallmentBanners() {
		console.info('Initialising PayPal Installments banners');
		console.info('CartAmount = ' + payPalBannerSettings.cartAmount);
		var banners = document.querySelectorAll('.paypal-installments');
		banners.forEach(function (bannerElement) {
			var position = bannerElement.dataset.ppinstPos;
			console.info('found banner on position ' + position);
			if (payPalBannerSettings.positions && payPalBannerSettings.positions[position]) {
				console.info('settings found for position ' + position);
				console.debug(payPalBannerSettings.positions[position]);
				if (payPalBannerSettings.positions[position].style.layout === 'none') {
					console.info('position disabled');
					return;
				}

				var amount = 0.00;
				if (payPalBannerSettings.cartAmount) {
					amount += payPalBannerSettings.cartAmount;
				}
				var p = document.querySelector('div.current-price-container');
				if (p) {
					amount += 0.01 * parseFloat(p.innerText.replace(/.*?(((\d{1,3}[.,])+)(\d{2})).*/, '$1').replace(/[.,]/g, ''));
				}
				if (amount === 0.00) {
					console.debug('Not showing PayPal Installments banner for amount ' + amount);
				}

				if (bannerElement.classList.contains('paypal-installments-cartbottom')) {
					var observerTarget = document.querySelector('div.shopping-cart-button');
					if (observerTarget) {
						var cartSumElement = document.querySelector('tr.total.sum td:nth-child(2)');
						var amountString = '0';
						if (cartSumElement) {
							amountString = cartSumElement.textContent.trim();
						} else {
							cartSumElement = document.querySelector('tr.footer.total td:nth-child(2)');
							if (cartSumElement) {
								amountString = cartSumElement.textContent.trim().replace(/(\n|\t|\.|\,)/g, '').replace(/.*?([0-9.,]+)\s+EUR.*/, '$1');
							}
						}
						amount = 0.01 * parseInt(amountString.replace(/[^0-9]/g, ''));
						console.info('cart amount ' + amount);

						var observer = new MutationObserver(function (mutations, observer) {
							mutations.forEach(function (mutation) {
								if (mutation.removedNodes.length > 0) {
									console.info('re-init PayPal installments banner');
									initInstallmentBanners();
								}
							});
						});
						observer.observe(observerTarget, { childList: true });
					}
				}

				paypal.Messages({
					amount: amount,
					currency: payPalBannerSettings.currency,
					style: payPalBannerSettings.positions[position].style,
					placement: payPalBannerSettings.positions[position].placement
				}).render(bannerElement).then(function () {
					var legacyInstallmentContainer = document.querySelector('.paypalinstallmentcontainer');
					if (legacyInstallmentContainer) {
						legacyInstallmentContainer.remove();
					}
				});
			}
		});
	};

	var paypalSdkLoaded = function paypalSdkLoaded() {
		console.info('PayPalSDK loaded');
		if (window.location.pathname.match(/shopping_cart.php/)) {
			console.info('Initializing ECS button');
			initJSSDKPayPalButtonECS();
		}
		if (window.location.pathname.match(/checkout_payment.php/)) {
			console.info('Initializing PayPal on payment page');
			initCheckoutPayment();
		}
		initInstallmentBanners();
	};

	var readyCallback = function readyCallback() {
		var jssrc = '';
		if (typeof payPalButtonSettings !== 'undefined' && payPalButtonSettings.jssrc) {
			jssrc = payPalButtonSettings.jssrc;
		} else if (typeof payPalBannerSettings !== 'undefined' && payPalBannerSettings.jssrc) {
			jssrc = payPalBannerSettings.jssrc;
		}

		if (jssrc && typeof window.paypal === 'undefined') {
			var jssdk = document.createElement('script');
			jssdk.src = payPalButtonSettings.jssrc ? payPalButtonSettings.jssrc : payPalBannerSettings.jssrc;
			jssdk.onload = paypalSdkLoaded;

			if (currentScript) {
				currentScript.parentNode.insertBefore(jssdk, currentScript);
			} else {
				document.querySelector('script:last-of-type').parentNode.appendChild(jssdk);
			}
		} else {
			console.info('PayPal JSSDK unavailable');
		}
	};

	if (document.readyState === 'complete' || document.readyState !== 'loading' && !document.documentElement.doScroll) {
		readyCallback();
	} else {
		document.addEventListener('DOMContentLoaded', readyCallback);
	}
})();
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
